/*
	The Universe Development Kit
	Copyright (C) 2000  Sean O'Neil
	s_p_oneil@hotmail.com

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __Font_h__
#define __Font_h__

/*******************************************************************************
* Class: CFont
********************************************************************************
* This is just a quick and dirty class for using wglUseFontBitmaps. I don't like
* using it because it's slow, but for now that's all I have to use for fonts.
* It would be nice to test drawing to a normal Windows bitmap using GDI commands,
* then blitting the text to OpenGL somehow.
*******************************************************************************/
class CFont
{
protected:
	int m_nListBase;
	float m_fXPos;
	float m_fYPos;

public:
	CFont(HDC hDC=NULL)
	{
		m_nListBase = -1;
		m_fXPos = 0;
		m_fYPos = 0;
		if(hDC)
		{
			m_nListBase = glGenLists(256);
			wglUseFontBitmaps(hDC, 0, 255, m_nListBase);
		}
	}
	~CFont()	{ Cleanup(); }
	void Init(HDC hDC)
	{
		Cleanup();
		m_nListBase = glGenLists(256);
		wglUseFontBitmaps(hDC, 0, 255, m_nListBase);
	}
	void Cleanup()
	{
		if(m_nListBase != -1)
		{
			glDeleteLists(m_nListBase, 256);
			m_nListBase = -1;
		}
	}
	void SetPosition(int x, int y)
	{
		m_fXPos = (float)x;
		m_fYPos = (float)y;
	}
	void Begin()
	{
		glDisable(GL_LIGHTING);
		glPushMatrix();
		glLoadIdentity();
		glMatrixMode(GL_PROJECTION);
		glPushMatrix();
		glLoadIdentity();
		gluOrtho2D(0, 640, 0, 480);
	}
	void Print(const char *pszMessage)
	{
		glRasterPos2f(m_fXPos, m_fYPos);
		glListBase(m_nListBase);
		glCallLists(strlen(pszMessage), GL_UNSIGNED_BYTE, pszMessage);
	}
	void End()
	{
		glPopMatrix();
		glMatrixMode(GL_MODELVIEW);
		glPopMatrix();
		glEnable(GL_LIGHTING);
	}
};

#endif // __Font_h__

